<?php

// --------------------------
// Custom Backpack Routes
// --------------------------
// This route file is loaded automatically by Backpack\Base.
// Routes you generate using Backpack\Generators will be placed here.

Route::group([
    'prefix'     => config('backpack.base.route_prefix', 'admin'),
    'middleware' => [
        config('backpack.base.web_middleware', 'web'),
        config('backpack.base.middleware_key', 'admin'),
    ],
    'namespace'  => 'Modules\Admin\Http\Controllers',
    'name'       => 'admin.',
], function () { // custom admin routes

    // Dashboard
    Route::get('dashboard', 'AdminController@dashboard')->name('backpack.dashboard');
    Route::get('/', 'AdminController@redirect')->name('backpack');

    // CRUD
    Route::crud('posts', 'PostCrudController');
    Route::crud('tags', 'TagCrudController');
    Route::crud('users', 'UserCrudController');
    Route::crud('organizations', 'OrganizationCrudController');
    Route::crud('reports', 'ReportCrudController');
    Route::crud('abuses', 'AbuseCrudController');
    Route::crud('places', 'PlaceCrudController');
    Route::crud('premium_cities', 'PremiumCityCrudController');
    Route::group(['prefix' => 'users/{user_id}'], function () {
        Route::crud('reports', 'UserReportCrudController');
    });
    Route::group(['prefix' => 'organizations/{organization_id}'], function () {
        Route::crud('reports', 'OrganizationReportCrudController');
    });
}); // this should be the absolute last line of this file
