@if ($paginator->hasPages())
<div class="flex-auto items-center text-gray-800">
  {{-- Previous Page Link --}}
  @if ($paginator->onFirstPage())
  <span class="bg-white rounded-l rounded-sm border-t border-b border-l px-3 py-2 cursor-not-allowed no-underline">
    &laquo;
  </span>
  @else
  <a class="bg-white rounded-l rounded-sm border-t border-b border-l px-3 py-2 no-underline" href="{{ $paginator->previousPageUrl() }}" rel="prev">
    &laquo;
  </a>
  @endif

  {{-- Pagination Elements --}}
  @foreach ($elements as $element)
  {{-- "Three Dots" Separator --}}
  @if (is_string($element))
  <span class="bg-white border-t border-b border-l px-3 py-2 cursor-not-allowed no-underline">
    {{ $element }}
  </span>
  @endif

  {{-- Array Of Links --}}
  @if (is_array($element))
  @foreach ($element as $page => $url)
  @if ($page == $paginator->currentPage())
  <span class="bg-white border-t border-b border-l px-3 py-2 no-underline text-orange-500">
    {{ $page }}
  </span>
  @else
  <a class="bg-white border-t border-b border-l px-3 py-2 no-underline" href="{{ $url }}">
    {{ $page }}
  </a>
  @endif
  @endforeach
  @endif
  @endforeach

  {{-- Next Page Link --}}
  @if ($paginator->hasMorePages())
  <a class="bg-white rounded-r rounded-sm border px-3 py-2 no-underline" href="{{ $paginator->nextPageUrl() }}" rel="next">
    &raquo;
  </a>
  @else
  <span class="bg-white rounded-r rounded-sm border px-3 py-2 no-underline cursor-not-allowed">
    &raquo;
  </span>
  @endif
</div>
@endif