# config valid for current version and patch releases of Capistrano
lock "~> 3.13.0"

set :application, "AnimalResearch"
set :keep_releases, 3

set :use_sudo, true

append :linked_files,
    '.env',
    'storage/oauth-private.key',
    'storage/oauth-public.key'

append :linked_dirs,
    'storage/app',
    'storage/framework/cache',
    'storage/framework/sessions',
    'storage/framework/views',
    'storage/logs',
    'storage/medialibrary',
    'storage/tmp'

###############################################################################

namespace :composer do

    desc "Run composer install in release_path."
    task :install do
    	on roles(:all) do
        	within release_path do
            	execute "composer", "install", "--optimize-autoloader", "--no-dev", "--quiet"
            end
        end
    end
end

###############################################################################

namespace :laravel do

    desc "Setup Laravel folder permissions."
    task :permissions do
    	on roles(:all) do
            execute "sudo", "chmod", "-R ug+rwx #{shared_path}/storage/ #{release_path}/bootstrap/cache/"
            execute "sudo", "chgrp", "-R www-data #{shared_path}/storage/ #{release_path}/bootstrap/cache/"
        end
    end

    desc "Run Laravel Artisan migrate."
    task :migrate do
    	on roles(:all) do
            within release_path do
	        execute "php", "artisan", "migrate", "--force"
            end
        end
    end

    desc "Optimize Configuration Loading"
    task :config_cache do
    	on roles(:all) do
            within release_path do
            	execute "php", "artisan", "config:cache"
            end
        end
    end

    desc "Optimize Route Loading"
    task :route_cache do
    	on roles(:all) do
            within release_path do
            	execute "php", "artisan", "route:cache"
            end
        end
    end

    desc "Optimize View Loading"
    task :view_cache do
    	on roles(:all) do
            within release_path do
            	execute "php", "artisan", "view:cache"
            end
        end
    end

    desc "Create Storage SymLink"
    task :storage_link do
    	on roles(:all) do
            within release_path do
            	execute "php", "artisan", "storage:link"
            end
        end
    end

end

###############################################################################

namespace :passport do

    desc "Generate Passport Keys."
    task :keys do
    	on roles(:all) do
            within release_path do
	        execute "php", "artisan", "passport:keys"
            end
        end
    end

end

###############################################################################

namespace :deploy do
    after :publishing, "composer:install"
    after :publishing, "laravel:permissions"
    after :publishing, "laravel:migrate"
    after :publishing, "passport:keys"
    after :publishing, "laravel:config_cache"
    after :publishing, "laravel:route_cache"
    after :publishing, "laravel:view_cache"
    after :publishing, "laravel:storage_link"

end

###############################################################################
