<?php

namespace App\Http\Middleware;

use Illuminate\Support\Facades\URL;
use Closure;

class Locale
{

    private const LOCALE_KEY = 'locale';

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $lang = $request[self::LOCALE_KEY];

        URL::defaults([self::LOCALE_KEY => $lang]);
        session([self::LOCALE_KEY => $lang]);
        view()->share(self::LOCALE_KEY, $lang);
        app()->setLocale($lang);

        $request->route()->forgetParameter(self::LOCALE_KEY);

        return $next($request);
    }
}
