<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use Modules\Common\Entities\Report;


class SetExpirationToReports extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'reports:set-expiration';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Set expiration to reports';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        Report::withTrashed()->chunk(25, function ($reports) {
            foreach ($reports as $report) {
                if (!$report->expires_at) {
                    $report->setExpiration();
                }
            }
        });
    }

    // End of class
}
