<?php

namespace Modules\User\Rules;

use Illuminate\Contracts\Validation\Rule;

use Auth;
use Hash;

class MatchCurrentPassword implements Rule
{

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return Hash::check($value, Auth::user()->password);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return __('validation.match_current_password');
    }
    
    // End of class
}
