@extends('user::_layouts.authenticated.layout')

@section('title', __('messages.global.registered_animal_detail'))

@section('content')

  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">{{ __('messages.global.registered_animal_detail') }}</h4>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table">
              <tr>
                <th>{{ __('messages.global.animal_name') }}</th>
                <td>{{ $registeredAnimal->name }}</td>
              </tr>
              <tr>
                <th>{{ __('messages.global.pictures') }}</th>
                <td>
                  @foreach ($registeredAnimal->getMedia() as $media)
                    <a href="{{ $media->getFullUrl('medium') }}" target="_blank">
                      <img src="{{ $media->getFullUrl('thumb') }}" alt=""
                        style="width: 40px; height: 40px; object-fit: cover;">
                    </a>
                  @endforeach
                </td>
              </tr>
              <tr>
                <th>{{ __('messages.global.animal_species') }}</th>
                <td>{{ $registeredAnimal->animalSpeciesFormatted }}</td>
              </tr>
              <tr>
                <th>{{ __('messages.global.identification_type') }}</th>
                <td>{{ $registeredAnimal->identificationtypeFormatted }}</td>
              </tr>
              <tr>
                <th>{{ __('messages.global.identification_number') }}</th>
                <td>{{ $registeredAnimal->identification_number }}</td>
              </tr>
              <tr>
                <th>{{ __('messages.global.comment') }}</th>
                <td>{{ $registeredAnimal->comment }}</td>
              </tr>
              <tr>
                <th>{{ __('messages.global.actions') }}</th>
                <td>
                  <a class="btn btn-round btn-warning"
                    href="{{ route('user.registered_animals.edit', $registeredAnimal) }}">{{ __('messages.global.edit') }}</a>
                  <a class="btn btn-round btn-danger" href="#" data-toggle="modal"
                    data-target="#confirm-delete-registered_animal-dialog"
                    data-href="{{ route('user.registered_animals.delete', $registeredAnimal) }}">{{ __('messages.global.delete') }}</a>
                </td>
              </tr>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  {{-- Confirm Delete Dialog --}}
  @include('user::_layouts.authenticated._partials.confirm_delete_dialog')

@endsection
