@extends('user::_layouts.authenticated.layout')

@section('title', __('messages.global.edit_my_animal'))

@section('css')
  {{-- Dropzone --}}
  @include(
      'user::_layouts.authenticated._partials.dropzone_images_css'
  )
@endsection

@section('content')
  <div class="row">

    <div class="col-lg-4">
    </div>

    <div class="col-lg-8 order-first">

      <div class="card card-user">
        <div class="card-header">
          <h5 class="card-title">{{ __('messages.global.edit_my_animal') }}</h5>
        </div>
        <div class="card-body">
          <form method="post" action="{{ route('user.registered_animals.update', $registeredAnimal) }}">
            {{ csrf_field() }}

            <div class="row mb-3">
              <div class="col-md-12">
                <div class="form-group">
                  <label for="images[]">{{ __('messages.global.pictures') }}</label>
                  <div class="form-control dropzone" id="dropzone" style="border: 1px solid #dddddd;"></div>
                </div>
                @if ($errors->has('images'))
                  <span class="small text-danger">{{ $errors->first('images') }}</span>
                @endif
                @if ($errors->has('images.0'))
                  <span class="small text-danger">{{ $errors->first('images.0') }}</span>
                @endif
              </div>
            </div>

            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="name">{{ __('messages.global.animal_name') }}</label>
                  <input type="text" id="name" name="name" class="form-control"
                    placeholder="{{ __('messages.global.animal_name') }}"
                    value="{{ old('name', $registeredAnimal->name) }}">
                  @if ($errors->has('name'))
                    <span class="small text-danger">{{ $errors->first('name') }}</span>
                  @endif
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="animal_species">{{ __('messages.global.animal_species') }}</label>
                  <select id="animal_species" name="animal_species" class="custom-select"
                    placeholder="{{ __('messages.global.animal_species') }}">
                    <option>-</option>

                    {{-- Pet --}}
                    <optgroup label="{{ __('messages.animal_species_categories.pet') }}">

                      {{-- Pet Dog --}}
                    <optgroup label="{{ __('messages.animal_species_categories.pet_dog') }}">
                      @foreach ($animalSpecies as $species)
                        @if (Str::startsWith($species, 'pet_dog'))
                          <option value="{{ $species }}"
                            {{ old('animal_species', $registeredAnimal->animal_species) == $species ? 'selected' : '' }}>
                            {{ __('messages.animal_species.' . $species) }}</option>
                        @endif
                      @endforeach
                    </optgroup>

                    {{-- Pet Cat --}}
                    <optgroup label="{{ __('messages.animal_species_categories.pet_cat') }}">
                      @foreach ($animalSpecies as $species)
                        @if (Str::startsWith($species, 'pet_cat'))
                          <option value="{{ $species }}"
                            {{ old('animal_species', $registeredAnimal->animal_species) == $species ? 'selected' : '' }}>
                            {{ __('messages.animal_species.' . $species) }}</option>
                        @endif
                      @endforeach
                    </optgroup>

                    {{-- Pet Other --}}
                    <optgroup label="{{ __('messages.animal_species_categories.pet_other') }}">
                      @foreach ($animalSpecies as $species)
                        @if (Str::startsWith($species, 'pet') && !Str::startsWith($species, 'pet_dog') && !Str::startsWith($species, 'pet_cat'))
                          <option value="{{ $species }}"
                            {{ old('animal_species', $registeredAnimal->animal_species) == $species ? 'selected' : '' }}>
                            {{ __('messages.animal_species.' . $species) }}</option>
                        @endif
                      @endforeach
                    </optgroup>
                    </optgroup>

                    {{-- Livestock --}}
                    <optgroup label="{{ __('messages.animal_species_categories.livestock') }}">
                      @foreach ($animalSpecies as $species)
                        @if (Str::startsWith($species, 'livestock'))
                          <option value="{{ $species }}"
                            {{ old('animal_species', $registeredAnimal->animal_species) == $species ? 'selected' : '' }}>
                            {{ __('messages.animal_species.' . $species) }}</option>
                        @endif
                      @endforeach
                    </optgroup>

                    {{-- Circus --}}
                    <optgroup label="{{ __('messages.animal_species_categories.circus') }}">
                      @foreach ($animalSpecies as $species)
                        @if (Str::startsWith($species, 'circus'))
                          <option value="{{ $species }}"
                            {{ old('animal_species', $registeredAnimal->animal_species) == $species ? 'selected' : '' }}>
                            {{ __('messages.animal_species.' . $species) }}</option>
                        @endif
                      @endforeach
                    </optgroup>

                    {{-- Wild --}}
                    <optgroup label="{{ __('messages.animal_species_categories.wild') }}">
                      @foreach ($animalSpecies as $species)
                        @if (Str::startsWith($species, 'wild') && !Str::startsWith($species, 'wild_aquatic'))
                          <option value="{{ $species }}"
                            {{ old('animal_species', $registeredAnimal->animal_species) == $species ? 'selected' : '' }}>
                            {{ __('messages.animal_species.' . $species) }}</option>
                        @endif
                      @endforeach
                    </optgroup>

                    {{-- Wild Aquatic --}}
                    <optgroup label="{{ __('messages.animal_species_categories.wild_aquatic') }}">
                      @foreach ($animalSpecies as $species)
                        @if (Str::startsWith($species, 'wild_aquatic'))
                          <option value="{{ $species }}"
                            {{ old('animal_species', $registeredAnimal->animal_species) == $species ? 'selected' : '' }}>
                            {{ __('messages.animal_species.' . $species) }}</option>
                        @endif
                      @endforeach
                    </optgroup>

                  </select>
                  @if ($errors->has('animal_species'))
                    <span class="small text-danger">{{ $errors->first('animal_species') }}</span>
                  @endif
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="identification_type">{{ __('messages.global.identification_type') }}</label>
                  <select id="identification_type" name="identification_type" class="custom-select"
                    placeholder="{{ __('messages.global.identification_type') }}">
                    <option value="">-</option>
                    @foreach ($identificationTypes as $identificationType)
                      <option value="{{ $identificationType }}"
                        {{ old('identification_type', $registeredAnimal->identification_type) == $identificationType ? 'selected' : '' }}>
                        {{ __('messages.identification_type.' . $identificationType) }}</option>
                    @endforeach
                  </select>
                  @if ($errors->has('identification_type'))
                    <span class="small text-danger">{{ $errors->first('identification_type') }}</span>
                  @endif
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="identification_number">{{ __('messages.global.identification_number') }}</label>
                  <input type="text" id="identification_number" name="identification_number" class="form-control"
                    placeholder="{{ __('messages.global.identification_number') }}"
                    value="{{ old('identification_number', $registeredAnimal->identification_number) }}">
                  @if ($errors->has('identification_number'))
                    <span class="small text-danger">{{ $errors->first('identification_number') }}</span>
                  @endif
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-md-12">
                <div class="form-group">
                  <label for="comment">{{ __('messages.global.comment') }}</label>
                  <textarea id="comment" name="comment" class="form-control" rows="3"
                    placeholder="{{ __('messages.global.comment') }}">{{ old('comment', $registeredAnimal->comment) }}</textarea>
                  <div id="the-count" class="text-right small text-muted">
                    <span id="current">0</span>
                    <span id="maximum">/ 1000</span>
                  </div>
                  @if ($errors->has('comment'))
                    <span class="small text-danger">{{ $errors->first('comment') }}</span>
                  @endif
                </div>
              </div>
            </div>

            <div class="row">
              <div class="update ml-auto mr-auto">
                <button type="submit" name="edit-registered_animal"
                  class="btn btn-primary btn-round">{{ __('messages.global.update') }}</button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>

  </div>
@endsection

@section('js')

  {{-- Counter for comment textarea --}}
  <script>
    $('textarea#comment').keyup(function() {
      var characterCount = $(this).val().length,
        current = $('#current'),
        maximum = $('#maximum'),
        theCount = $('#the-count');
      if (characterCount > 1000) {
        $(this).val($(this).val().substring(0, 1000));
        characterCount = $(this).val().length;
        theCount.removeClass('text-muted');
        theCount.addClass('text-danger');
        theCount.addClass('text-bold');
      } else {
        theCount.addClass('text-muted');
        theCount.removeClass('text-danger');
        theCount.removeClass('text-bold');
      }

      current.text(characterCount);
    });
  </script>

  {{-- Dropzone --}}
  @include(
      'user::_layouts.authenticated._partials.dropzone_images_js'
  )

@endsection
