@extends('user::_layouts.authenticated.layout')

@section('title', __('messages.global.member_detail'))

@section('content')

  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">{{ __('messages.global.member_detail') }}</h4>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table">
              <tr>
                <th>{{ __('messages.global.email_address') }}</th>
                <td>{{ $member->email }}</td>
              </tr>
              <tr>
                <th>{{ __('messages.global.first_name') }}</th>
                <td>{{ $member->first_name }}</td>
              </tr>
              <tr>
                <th>{{ __('messages.global.last_name') }}</th>
                <td>{{ $member->last_name }}</td>
              </tr>

              <tr>
                <th>{{ __('messages.global.actions') }}</th>
                <td>
                  <a class="btn btn-round btn-warning"
                    href="{{ route('user.members.edit', $member) }}">{{ __('messages.global.edit') }}</a>
                  <a class="btn btn-round btn-danger" href="#" data-toggle="modal" data-target="#confirm-delete-member-dialog"
                    data-href="{{ route('user.members.delete', $member) }}">{{ __('messages.global.delete') }}</a>
                </td>
              </tr>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  {{-- Confirm Delete Dialog --}}
  @include('user::_layouts.authenticated._partials.confirm_delete_dialog')

@endsection
