@extends('user::_layouts.authenticated.layout')

@section('title', __('messages.global.members'))

@section('content')

  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <h4 class="card-title">{{ __('messages.global.members') }}</h4>
        </div>
        <div class="card-body">
          <div>
            <a class="btn btn-round btn-success"
              href="{{ route('user.members.create') }}">{{ __('messages.global.add_a_member') }}</a>
          </div>
          <div class="table-responsive">
            <table class="table">
              <thead class="text-primary">
                <th>
                  @sortablelink('email', __('messages.global.email_address'))
                </th>
                <th>
                  @sortablelink('first_name', __('messages.global.first_name'))
                </th>
                <th>
                  @sortablelink('last_name', __('messages.global.last_name'))
                </th>
                <th>
                  @sortablelink('created_at', __('messages.global.created_at'))
                </th>
                <th>
                  @sortablelink('reports_count', __('messages.global.reports_count'))
                </th>
                <th class="text-right">
                  {{ __('messages.global.actions') }}
                </th>
              </thead>
              <tbody>
                @forelse($members as $member)
                  <tr>
                    <td>
                      {{ $member->email }}
                    </td>
                    <td>
                      {{ $member->first_name }}
                    </td>
                    <td>
                      {{ $member->last_name }}
                    </td>
                    <td>
                      {{ $member->createdAtDateTimeFormatted }}
                    </td>
                    <td>
                      {{ $member->reports_count }}
                    </td>
                    <td class="text-right">
                      <a class="btn btn-round btn-success"
                        href="{{ route('user.members.show', $member) }}">{{ __('messages.global.show') }}</a>
                      <a class="btn btn-round btn-warning"
                        href="{{ route('user.members.edit', $member) }}">{{ __('messages.global.edit') }}</a>
                      <a class="btn btn-round btn-danger" href="#" data-toggle="modal"
                        data-target="#confirm-delete-member-dialog"
                        data-href="{{ route('user.members.delete', $member) }}">{{ __('messages.global.delete') }}</a>
                    </td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="5">
                      {{ __('messages.global.no_members') }}
                    </td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  {{-- Confirm Delete Dialog --}}
  @include('user::_layouts.authenticated._partials.confirm_delete_dialog')

@endsection
