@extends('user::_layouts.authenticated.layout')

@section('title', __('messages.global.edit_member'))

@section('content')
  <div class="row">

    <div class="col-lg-4">
    </div>

    <div class="col-lg-8 order-first">

      <div class="card card-user">
        <div class="card-header">
          <h5 class="card-title">{{ __('messages.global.edit_member') }}</h5>
        </div>
        <div class="card-body">
          <form method="post" action="{{ route('user.members.update', $member) }}">
            {{ csrf_field() }}

            <div class="row">
              <div class="col-md-4">
                <div class="form-group">
                  <label for="email">{{ __('messages.global.email_address') }}</label>
                  <input type="text" id="email" name="email" class="form-control" disabled
                    placeholder="{{ __('messages.global.email_address') }}" value="{{ $member->email }}">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label for="first_name">{{ __('messages.global.first_name') }}</label>
                  <input type="text" id="first_name" name="first_name" class="form-control"
                    placeholder="{{ __('messages.global.first_name') }}"
                    value="{{ old('first_name', $member->first_name) }}">
                  @if ($errors->has('first_name'))
                    <span class="small text-danger">{{ $errors->first('first_name') }}</span>
                  @endif
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label for="last_name">{{ __('messages.global.last_name') }}</label>
                  <input type="text" id="last_name" name="last_name" class="form-control"
                    placeholder="{{ __('messages.global.last_name') }}"
                    value="{{ old('last_name', $member->last_name) }}">
                  @if ($errors->has('last_name'))
                    <span class="small text-danger">{{ $errors->first('last_name') }}</span>
                  @endif
                </div>
              </div>
            </div>

            <div class="row">
              <div class="update ml-auto mr-auto">
                <button type="submit" name="edit-member"
                  class="btn btn-primary btn-round">{{ __('messages.global.update') }}</button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>

  </div>
@endsection
