@extends('landing::_layouts.master')

@section('title', __('messages.global.register'))

@section('content')
  {{-- Header --}}
  <header class="pt-24">
    <div class="mx-auto container px-3 py-16">
      <div class="w-full text-center">
        <h1 class="my-4 text-5xl font-bold leading-tight">{{ __('messages.global.user_area') }}</h1>
      </div>
    </div>
  </header>


  {{-- Starting gradient --}}
  @include('landing::_layouts/_partials/gradient-start', ['fill' => '#f7fafc'])


  {{-- Register Form --}}
  @include('user::auth/_includes/register_form')


  <hr>


  {{-- Login --}}
  <section class="bg-white py-16 mx-auto">
    <div class="mx-auto text-center flex flex-wrap">
      <div class=" mx-auto mb-16">
        <h1 class="w-full text-5xl font-bold leading-tight text-gray-800">
          {{ __('messages.global.already_registered') }}</h1>
        <div class="w-full mt-4">
          <div class="h-1 mx-auto gradient w-64 opacity-25 my-0 py-0 rounded-t"></div>
        </div>
      </div>
    </div>
    <div class="mx-auto text-center">
      <a class="gradient text-white font-bold rounded-full mt-4 lg:mt-0 py-4 px-8 opacity-75 hover:opacity-100 shadow"
        href="{{ route('user.auth.login') }}">
        {{ __('messages.global.login') }}
      </a>
    </div>
  </section>


  {{-- Ending gradient --}}
  @include('landing::_layouts/_partials/gradient-end', ['fill' => '#ffffff'])

@endsection
