@extends('landing::_layouts.master')

@section('title', __('messages.global.reset_password'))

@section('content')


  {{-- Header --}}
  <header class="pt-24">
    <div class="mx-auto container px-3 py-16">
      <div class="w-full text-center">
        <h1 class="my-4 text-5xl font-bold leading-tight">{{ __('messages.global.user_area') }}</h1>
      </div>
    </div>
  </header>


  {{-- Starting gradient --}}
  @include('landing::_layouts/_partials/gradient-start', ['fill' => '#f7fafc'])


  {{-- Content --}}
  <section class="bg-gray-100 py-16 mx-auto">
    <div class="mx-auto container">

      {{-- Title --}}
      <div class="mx-auto text-center flex flex-wrap">
        <div class=" mx-auto mb-16">
          <h1 class="w-full text-5xl font-bold leading-tight text-gray-800">
            {{ __('messages.global.reset_password') }}</h1>
          <div class="w-full mt-4">
            <div class="h-1 mx-auto gradient w-64 opacity-25 my-0 py-0 rounded-t"></div>
          </div>
        </div>
      </div>

      {{-- Form --}}
      <div class="mx-auto text-left text-black text-xl flex">
        {{-- Form --}}
        <form method="post" action="{{ route('password.update') }}"
          class="mx-auto bg-white shadow rounded-xl px-6 py-6">
          {{-- CSRF --}}
          @csrf

          {{-- Token --}}
          <input type="hidden" name="token" value="{{ $token }}">

          {{-- Account Type Field --}}
          <div class="mb-6">
            <label class="block text-gray-700 text-sm font-bold mb-2" for="account_type">
              {{ __('messages.global.account_type') }}
            </label>
            <select name="account_type"
              class="bg-white shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
              <option value="{{ Modules\Common\Entities\User::ACCOUNT_TYPE_INDIVIDUAL }}"
                {{ ($account_type ?? old('account_type')) == Modules\Common\Entities\User::ACCOUNT_TYPE_INDIVIDUAL ? 'selected' : '' }}>
                {{ __('messages.account_type.individual') }}</option>
              <option value="{{ Modules\Common\Entities\User::ACCOUNT_TYPE_ORGANIZATION }}"
                {{ ($account_type ?? old('account_type')) == Modules\Common\Entities\User::ACCOUNT_TYPE_ORGANIZATION ? 'selected' : '' }}>
                {{ __('messages.account_type.organization') }}</option>
              <option value="{{ Modules\Common\Entities\User::ACCOUNT_TYPE_ACCESS }}"
                {{ ($account_type ?? old('account_type')) == Modules\Common\Entities\User::ACCOUNT_TYPE_ACCESS ? 'selected' : '' }}>
                {{ __('messages.account_type.access') }}</option>
              {{ __('messages.global.access') }}</option>
            </select>
            @if ($errors->has('account_type'))
              <p class="text-red-500 text-xs italic">{{ $errors->first('account_type') }}</p>
            @endif
          </div>

          {{-- Email Field --}}
          <div class="mb-6">
            <label class="block text-gray-700 text-sm font-bold mb-2" for="email">
              {{ __('messages.global.email_address') }}
            </label>
            <input type="text" name="email" value="{{ $email ?? old('email') }}"
              placeholder="{{ __('messages.global.email_address') }}"
              class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            @if ($errors->has('email'))
              <p class="text-red-500 text-xs italic">{{ $errors->first('email') }}</p>
            @endif
          </div>

          {{-- Password Field --}}
          <div class="mb-6">
            <label class="block text-gray-700 text-sm font-bold mb-2" for="password">
              {{ __('messages.global.password') }}
            </label>
            <input type="password" name="password" value="{{ old('password') }}"
              placeholder="{{ __('messages.global.password') }}"
              class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            @if ($errors->has('password'))
              <p class="text-red-500 text-xs italic">{{ $errors->first('password') }}</p>
            @endif
          </div>

          {{-- Password Confirmation Field --}}
          <div class="mb-6">
            <label class="block text-gray-700 text-sm font-bold mb-2" for="password_confirmation">
              {{ __('messages.global.password_confirmation') }}
            </label>
            <input type="password" name="password_confirmation" value="{{ old('password_confirmation') }}"
              placeholder="{{ __('messages.global.password_confirmation') }}"
              class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            @if ($errors->has('password_confirmation'))
              <p class="text-red-500 text-xs italic">{{ $errors->first('password_confirmation') }}</p>
            @endif
          </div>

          <div class="flex items-center justify-between space-x-4">
            {{-- Submit Button --}}
            <button type="submit"
              class="mx-auto gradient text-white font-bold rounded-full py-2 px-4 opacity-75 hover:opacity-100 shadow">
              {{ __('messages.global.update') }}
            </button>
          </div>
        </form>
      </div>

    </div>
  </section>


  {{-- Ending gradient --}}
  @include('landing::_layouts/_partials/gradient-end', ['fill' => '#f7fafc'])


@endsection
