@extends('landing::_layouts.master')

@section('title', __('messages.global.login'))

@section('content')


{{-- Header --}}
<header class="pt-24">
  <div class="mx-auto container px-3 py-16">
    <div class="w-full text-center">
      <h1 class="my-4 text-5xl font-bold leading-tight">{{ __('messages.global.user_area') }}</h1>
    </div>
  </div>
</header>


{{-- Starting gradient --}}
@include('landing::_layouts/_partials/gradient-start', ['fill' => '#f7fafc'])


{{-- Login Form --}}
@include('user::auth/_includes/login_form')

<hr>

{{-- Register --}}
<section class="bg-white py-16 mx-auto">
  <div class="mx-auto text-center flex flex-wrap">
    <div class=" mx-auto mb-16">
      <h1 class="w-full text-5xl font-bold leading-tight text-gray-800">{{ __('messages.global.not_yet_account') }}</h1>
      <div class="w-full mt-4">
        <div class="h-1 mx-auto gradient w-64 opacity-25 my-0 py-0 rounded-t"></div>
      </div>
    </div>
  </div>
  <div class="mx-auto text-center">
    <a class="gradient text-white font-bold rounded-full mt-4 lg:mt-0 py-4 px-8 opacity-75 hover:opacity-100 shadow" href="{{ route('user.auth.register') }}">
      {{ __('messages.global.create_account') }}
    </a>
  </div>
</section>


{{-- Ending gradient --}}
@include('landing::_layouts/_partials/gradient-end', ['fill' => '#ffffff'])


@endsection
