<section class="bg-gray-100 py-16 mx-auto">
  <div class="mx-auto container">

    {{-- Flash Messages --}}
    @if (session('status'))
      <div
        class="mx-auto w-full lg:w-1/2 bg-teal-100 border-t-4 border-teal-500 rounded-xl text-teal-900 px-4 py-3 mb-4 shadow"
        role="alert">
        <div class="text-center">
          <div>
            <p class="mx-auto font-bold">{{ session('status') }}</p>
            <p class="text-sm">&nbsp;</p>
          </div>
        </div>
      </div>
    @endif

    {{-- Blocked Account Flash Message --}}
    @if (Session::has('blocked') && Session::get('blocked'))
      <div
        class="mx-auto w-full lg:w-1/2 bg-red-100 border-t-4 border-red-500 rounded-xl text-red-900 px-4 py-3 mb-4 shadow"
        role="alert">
        <div class="text-center">
          <div>
            <p class="mx-auto font-bold">{{ __('auth.account_is_blocked') }}</p>
            <p class="text-sm">&nbsp;</p>
          </div>
        </div>
      </div>
    @endif

    {{-- Delete Account Confirmation Flash Message --}}
    @if (Session::has('delete_account.deleted') && Session::get('delete_account.deleted'))
      <div
        class="mx-auto w-full lg:w-1/2 bg-teal-100 border-t-4 border-teal-500 rounded-xl text-teal-900 px-4 py-3 mb-4 shadow"
        role="alert">
        <div class="text-center">
          <div>
            <p class="mx-auto font-bold">{{ __('messages.delete_account.deleted') }}</p>
            <p class="text-sm">&nbsp;</p>
          </div>
        </div>
      </div>
    @endif

    {{-- Title --}}
    <div class="mx-auto text-center flex flex-wrap">
      <div class=" mx-auto mb-16">
        <h1 class="w-full text-5xl font-bold leading-tight text-gray-800">{{ __('messages.global.login') }}
        </h1>
        <div class="w-full mt-4">
          <div class="h-1 mx-auto gradient w-64 opacity-25 my-0 py-0 rounded-t"></div>
        </div>
      </div>
    </div>

    {{-- Form --}}
    <div class="mx-auto text-left text-black text-xl flex">
      <form method="post" action="{{ route('user.auth.login') }}"
        class="mx-auto bg-white shadow rounded-xl px-6 py-6">
        {{-- CSRF --}}
        @csrf

        {{-- Account Type Field --}}
        <div class="mb-6">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="account_type">
            {{ __('messages.global.account_type') }}
          </label>
          <select name="account_type"
            class="bg-white shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            <option value="{{ Modules\Common\Entities\User::ACCOUNT_TYPE_INDIVIDUAL }}"
              {{ old('account_type') == Modules\Common\Entities\User::ACCOUNT_TYPE_INDIVIDUAL ? 'selected' : '' }}>
              {{ __('messages.account_type.individual') }}</option>
            <option value="{{ Modules\Common\Entities\User::ACCOUNT_TYPE_ORGANIZATION }}"
              {{ old('account_type') == Modules\Common\Entities\User::ACCOUNT_TYPE_ORGANIZATION ? 'selected' : '' }}>
              {{ __('messages.account_type.organization') }}</option>
          </select>
          @if ($errors->has('account_type'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('account_type') }}</p>
          @endif
        </div>

        {{-- Email Field --}}
        <div class="mb-6">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="email">
            {{ __('messages.global.email_address') }}
          </label>
          <input type="text" name="email" value="{{ old('email') }}"
            placeholder="{{ __('messages.global.email_address') }}"
            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
          @if ($errors->has('email'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('email') }}</p>
          @endif
        </div>

        {{-- Password Field --}}
        <div class="mb-6" x-data="{ show: true }">
          <label class="block text-gray-700 text-sm font-bold mb-2" for="password">
            {{ __('messages.global.password') }}
          </label>
          <div class="relative">
            <input :type="show ? 'password' : 'text'" name="password" value="{{ old('password') }}"
              placeholder="{{ __('messages.global.password') }}"
              class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            <div class="absolute inset-y-0 right-0 pr-3 flex items-center text-sm leading-5">
              <i @click="show = !show" :class="{'hidden': !show, 'fa fa-eye text-gray-700':show }"></i>
              <i @click="show = !show" :class="{'fa fa-eye-slash text-gray-700': !show, 'hidden':show }"></i>
            </div>
          </div>
          @if ($errors->has('password'))
            <p class="text-red-500 text-xs italic">{{ $errors->first('password') }}</p>
          @endif
        </div>

        {{-- Remember Field --}}
        <div class="mb-6">
          <input type="checkbox" name="remember" {{ old('remember') ? 'checked' : '' }}
            placeholder="{{ __('messages.global.remember_me') }}" class="shadow">
          <label class="text-gray-700 text-sm font-bold mb-2" for="remember">
            {{ __('messages.global.remember_me') }}
          </label>
        </div>

        <div class="flex items-center justify-between space-x-4">
          {{-- Submit Button --}}
          <button type="submit"
            class="gradient text-white font-bold rounded-full py-2 px-4 opacity-75 hover:opacity-100 shadow">
            {{ __('messages.global.signin') }}
          </button>
          <a class="inline-block align-baseline font-bold text-sm text-gray-500 hover:text-gray-800"
            href="{{ route('password.request') }}">
            {{ __('messages.global.forgot_password') }}
          </a>
        </div>
      </form>
    </div>

  </div>
</section>
