@include('user::_layouts._includes.theme')
<!DOCTYPE html>
<html lang="{{ config('app.locale') }}">

<head>
  <meta charset="utf-8" />
  <link rel="icon" type="image/png" href="{{ url('common/img/favicon.png') }}">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
  <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no'
    name='viewport'>

  {{-- Title --}}
  <title>@yield('title') | {{ config('app.name') }}</title>

  {{-- Fonts and icons --}}
  <link href="https://fonts.googleapis.com/css?family=Montserrat:400,700,200" rel="stylesheet">
  <link href="https://maxcdn.bootstrapcdn.com/font-awesome/latest/css/font-awesome.min.css" rel="stylesheet">

  {{-- CSS Files --}}
  <link href="{{ url('user/css/bootstrap.min.css') }}" rel="stylesheet">
  <link href="{{ url('user/css/paper-dashboard.css?v=2.1.1') }}" rel="stylesheet">
  <link href="{{ url('user/css/custom.css') }}" rel="stylesheet">

  {{--Additional CSS--}}
  @yield('css')

</head>

<body>

  {{-- Content --}}
  @yield('master_content')

  {{-- JS --}}
  <script src="{{ url('user/js/core/jquery.min.js') }}"></script>
  <script src="{{ url('user/js/core/popper.min.js') }}"></script>
  <script src="{{ url('user/js/core/bootstrap.min.js') }}"></script>
  <script src="{{ url('user/js/plugins/perfect-scrollbar.jquery.min.js') }}"></script>
  <script src="{{ url('user/js/plugins/moment.min.js') }}"></script>
  <script src="{{ url('user/js/plugins/bootstrap-switch.js') }}"></script>
  <script src="{{ url('user/js/plugins/sweetalert2.min.js') }}"></script>
  <script src="{{ url('user/js/plugins/jquery.validate.min.js') }}"></script>
  <script src="{{ url('user/js/plugins/jquery.bootstrap-wizard.js') }}"></script>
  <script src="{{ url('user/js/plugins/bootstrap-selectpicker.js') }}"></script>
  <script src="{{ url('user/js/plugins/bootstrap-datetimepicker.js') }}"></script>
  <script src="{{ url('user/js/plugins/jquery.dataTables.min.js') }}"></script>
  <script src="{{ url('user/js/plugins/bootstrap-tagsinput.js') }}"></script>
  <script src="{{ url('user/js/plugins/jasny-bootstrap.min.js') }}"></script>
  <script src="{{ url('user/js/plugins/fullcalendar/fullcalendar.min.js') }}"></script>
  <script src="{{ url('user/js/plugins/fullcalendar/daygrid.min.js') }}"></script>
  <script src="{{ url('user/js/plugins/fullcalendar/timegrid.min.js') }}"></script>
  <script src="{{ url('user/js/plugins/fullcalendar/interaction.min.js') }}"></script>
  <script src="{{ url('user/js/plugins/jquery-jvectormap.js') }}"></script>
  <script src="{{ url('user/js/plugins/nouislider.min.js') }}"></script>
  <script src="{{ url('user/js/plugins/chartjs.min.js') }}"></script>
  <script src="{{ url('user/js/plugins/bootstrap-notify.js') }}"></script>
  <script src="{{ url('user/js/paper-dashboard.min.js?v=2.1.1" type="text/javascript') }}"></script>

  {{-- Delete Confirmation Dialog --}}
  <script>
    $('#confirm-delete-dialog').on('show.bs.modal', function(e) {
      $('#confirm-delete-button').attr('href', $(e.relatedTarget).data('href'));
    });
    $('#confirm-delete-registered_animal-dialog').on('show.bs.modal', function(e) {
      $('#confirm-delete-registered_animal-button').attr('href', $(e.relatedTarget).data('href'));
    });
    $('#confirm-delete-member-dialog').on('show.bs.modal', function(e) {
      $('#confirm-delete-member-button').attr('href', $(e.relatedTarget).data('href'));
    });
  </script>

  {{-- Google Translate --}}
  <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit">
  </script>
  <script type="text/javascript">
    function googleTranslateElementInit() {
      new google.translate.TranslateElement({
        pageLanguage: 'fr'
      }, 'google_translate_element');
    }
  </script>

  {{-- Additional JS --}}
  @yield('js')

</body>

</html>
