<div class="sidebar" data-color="white" data-active-color="primary">

  <div class="logo">
    <a href="#" class="simple-text logo-mini">
      <div class="logo-image-small">
        <img src="{{ $user->avatar }}">
      </div>
    </a>
    <a href="#" class="simple-text logo-normal">
      {{ $user->full_name }}
    </a>
  </div>
  <div class="sidebar-wrapper">
    <ul class="nav">

      <li>
        <a href="{{ route('landing.home.index') }}">
          <i class="fa fa-home"></i>
          <p>{{ __('messages.global.home') }}</p>
        </a>
      </li>

      <li class="{{{ Route::currentRouteName() == 'user.profile.index' ? ' active' : '' }}}">
        <a href="{{ route('user.profile.index') }}">
          <i class="fa fa-user-circle"></i>
          <p>{{ __('messages.global.my_profile') }}</p>
        </a>
      </li>

      <li class="{{{ (Str::startsWith(Route::currentRouteName(), 'user.reports') && Route::currentRouteName() != 'user.reports.create') ? ' active' : '' }}}">
        <a href="{{ route('user.reports.index') }}">
          <i class="fa fa-bullhorn"></i>
          <p>{{ __('messages.global.my_reports') }}</p>
        </a>
      </li>

      @if($user->isIndividual && $user->isPremium)
      <li class="{{{ (Str::startsWith(Route::currentRouteName(), 'user.registered_animals')) ? ' active' : '' }}}">
        <a href="{{ route('user.registered_animals.index') }}">
          <i class="fa fa-paw"></i>
          <p>{{ __('messages.global.my_animals') }}</p>
        </a>
      </li>
      @endif

      @if($user->isIndividual || $user->isOrganization)
      <li class="{{{ (Str::startsWith(Route::currentRouteName(), 'user.reports.create')) ? ' active' : '' }}}">
        <a href="{{ route('user.reports.create') }}">
          <i class="fa fa-exclamation"></i>
          <p>{{ __('messages.global.report_his_lost_animal') }}</p>
        </a>
      </li>
      @endif

      @if($user->isOrganization && $user->is_verified)
      <li class="{{{ (Str::startsWith(Route::currentRouteName(), 'user.found_reports.create')) ? ' active' : '' }}}">
        <a href="{{ route('user.found_reports.create') }}">
          <i class="fa fa-exclamation"></i>
          <p>{{ __('messages.global.report_found_animal') }}</p>
        </a>
      </li>
      <li class="{{{ (Str::startsWith(Route::currentRouteName(), 'user.members')) ? ' active' : '' }}}">
        <a href="{{ route('user.members.index') }}">
          <i class="fa fa-users"></i>
          <p>{{ __('messages.global.members') }}</p>
        </a>
      </li>
      @endif

    </ul>
  </div>
</div>
