<?php

namespace Modules\User\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

use Illuminate\Validation\Rule;
use Modules\Common\Entities\User;


class UpdateProfileRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'first_name'            => ['required', 'regex:/^[\pL\s\-]+$/u', 'max:30'],
            'last_name'             => ['required', 'regex:/^[\pL\s\-]+$/u', 'max:30'],
            'gender'                => ['nullable', Rule::in(User::GENDERS)],
            'date_of_birth'         => ['nullable', 'date_format:Y-m-d'],
            'phone_is_private'      => ['nullable'],
            'address'               => ['nullable', 'string', 'max:180'],
            'location_latitude'     => ['nullable', 'numeric', 'min:-90',  'max:90'],
            'location_longitude'    => ['nullable', 'numeric', 'min:-180', 'max:180'],
            'location_zipcode'      => ['nullable', 'string', 'max:20'],
            'location_country'      => ['nullable', 'string', 'max:30'],
            'organization_function' => ['sometimes', 'required', 'string', 'max:30'],
        ];
    }

    // End of class
}
