<?php

namespace Modules\User\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

use Modules\User\Rules\MatchCurrentPassword;

class UpdatePasswordRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'password' => ['required', 'string', new MatchCurrentPassword()],
            'new_password' => ['required', 'string', 'min:8', 'confirmed'],
        ];
    }
}
