<?php

namespace Modules\User\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Modules\Common\Entities\User;


class MemberStoreRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'email'      => ['required', 'email:rfc,dns', 'max:180', 'unique:users,email,' . $this->id . ',id,account_type,' . User::ACCOUNT_TYPE_ACCESS],
            'first_name' => ['required', 'regex:/^[\pL\s\-]+$/u', 'max:30'],
            'last_name'  => ['required', 'regex:/^[\pL\s\-]+$/u', 'max:30'],
        ];
    }

    public function attributes()
    {
        return [
            //
        ];
    }

    // End of class
}
