<?php

namespace Modules\User\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

use Auth;


class CanAccessAlerts
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // Check if auth user is premium or organization access
        $user = Auth::user();
        if (!($user->is_premium || $user->is_organization_access)) {
            return $request->expectsJson()
                ? response(['message' => __('auth.account_type_not_allowed'), 'error' => 'account_type_not_allowed'], 403)
                : redirect()->route('user.profile.index');
        }

        return $next($request);
    }

    // End of class
}
