<?php

namespace Modules\User\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

use Auth;


class Active
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // Check if auth user is blocked
        if (Auth::user()->is_blocked) {
            Auth::guard('user')->logout();
            return $request->expectsJson()
                ? response(['message' => __('auth.account_is_blocked'), 'error' => 'account_is_blocked'], 403)
                : redirect()->route('user.auth.showLoginForm')->with('blocked', true);
        }

        return $next($request);
    }

    // End of class
}
