<?php

namespace Modules\User\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

use Auth;


class Account
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next, $accountType)
    {
        // Parse accountType
        $accountTypes = explode('|', $accountType);

        // Check if auth user has the specified account type
        if (!in_array(Auth::user()->account_type, $accountTypes)) {
            return $request->expectsJson()
                ? response(['message' => __('auth.account_type_not_allowed'), 'error' => 'account_type_not_allowed'], 403)
                : redirect()->route('user.profile.index');
        }

        return $next($request);
    }

    // End of class
}
