<?php

namespace Modules\User\Http\Controllers;

use Modules\Common\Entities\User;
use Modules\User\Http\Requests\UpdateProfileRequest;

class ProfileController extends AuthenticatedController
{

    public function index()
    {
        // Get values
        $genders = User::GENDERS;

        // Return view
        return view('user::profile.index', compact('genders'));
    }

    public function update(UpdateProfileRequest $request)
    {
        // Validate data
        $validated = $request->validated();

        // Set checkboxes value
        $validated['phone_is_private'] = $request->has('phone_is_private');

        // Add extras data for organization account
        if ($this->user->isOrganization) {
            $validated['extras->organization_function'] = $validated['organization_function'];
        }

        // Update resource
        $this->user->update($validated);

        // Redirect
        return redirect()
            ->route('user.profile.index')
            ->with('success', __('messages.global.updated'));
    }

    // End of class
}
