<?php

namespace Modules\User\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Modules\Common\Http\Requests\MediaStoreRequest;


class MediaController extends AuthenticatedController
{

    public function store(MediaStoreRequest $request)
    {
        // Handle file
        $fileInfos = $this->handleRequestFile($request, 'image');

        // Return response
        return response()->json($fileInfos);
    }

    private function handleRequestFile(Request $request, String $attributeName = 'file')
    {
        // Retrieve request file
        $file = $request->file($attributeName);

        // Store file
        $name = $file->store(null, 'tmp');

        // Return result
        return [
            'name'          => $name,
            'original_name' => $file->getClientOriginalName(),
        ];
    }

    // End of class
}
