<?php

namespace Modules\User\Http\Controllers;

use App\Http\Controllers\Controller;

use Auth;
use View;

class AuthenticatedController extends Controller
{
    protected $user;
    
    public function __construct()
    {
        $this->middleware(function ($request, $next) {

            // Retrieve authenticated user
            $this->user = Auth::guard('user')->user();

            // Share user in views
            View::share('user', $this->user);

            return $next($request);
        });
    }

    // End of class
}