@extends('blog::_layouts.master')

@section('title', __('messages.global.lost_animals'))

@section('content')


{{-- Header --}}
<header class="pt-24">
  <div class="mx-auto container px-3 py-16">
    <div class="w-full text-center">
      <h1 class="my-4 text-5xl font-bold leading-tight">
        {{ __('messages.global.lost_and_found_animals') }}
      </h1>
    </div>
  </div>
</header>


{{-- Starting gradient --}}
@include('landing::_layouts/_partials/gradient-start', ['fill' => '#f7fafc'])


{{-- Filters --}}
@if (auth('user')->check() && auth('user')->user()->hasVerifiedEmail())
@include('reports::/_includes/filters')
@else
<section class="bg-gray-100 py-16">
  <div class="mx-auto container">
    <div class="mx-auto text-center text-black text-xl w-full lg:w-1/2">
      <div class="bg-orange-100 border-t-4 border-orange-500 rounded-xl text-orange-700 px-4 py-3 shadow" role="alert">
        <div class="flex">
          <div>
            <p><a href="{{ route('user.auth.login') }}" class="font-bold">Connectez-vous</a> à votre compte utilisateur pour avoir accès aux filtres et aux informations de localisation.</p>
            <p class="text-sm">&nbsp;</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
@endif


{{-- Latest reports --}}
<section class="bg-gray-100 py-16">
  <div class="mx-auto container">
    <div class="mx-auto grid grid-cols-1 lg:grid-cols-2 gap-4 mb-16">
      @each('reports::_partials/report', $reports, 'report')
    </div>
    <div class="text-center">
      {{ $reports->links('pagination::default') }}
    </div>
  </div>
</section>


{{-- Ending gradient --}}
@include('landing::_layouts/_partials/gradient-end', ['fill' => '#f7fafc'])


@endsection


@section('js')
<script>
  // Autocompletion for address field
  var placeSearch, autocomplete;

  function initAutocomplete() {
  autocomplete = new google.maps.places.Autocomplete(
  document.getElementById('location_address'), {
  types: ['(regions)']
  });

  autocomplete.setFields(['geometry']);
  autocomplete.addListener('place_changed', fillInAddress);
  }

  function fillInAddress() {
  var place = autocomplete.getPlace();

  document.getElementById('location_latitude').value = place.geometry.location.lat();
  document.getElementById('location_longitude').value = place.geometry.location.lng();

  for (var i = 0; i < place.address_components.length; i++) {
  var addressType = place.address_components[i].types[0];
  if (componentForm[addressType]) {
  var val = place.address_components[i][componentForm[addressType]];
  document.getElementById(addressType).value = val;
  }
  }
  }

  // Bias the autocomplete object to the user's geographical location,
  // as supplied by the browser's 'navigator.geolocation' object.
  function geolocate() {
  if (navigator.geolocation) {
  navigator.geolocation.getCurrentPosition(function (position) {
  var geolocation = {
  lat: position.coords.latitude,
  lng: position.coords.longitude
  };
  var circle = new google.maps.Circle({
  center: geolocation,
  radius: position.coords.accuracy
  });
  autocomplete.setBounds(circle.getBounds());
  });
  }
  }

</script>
<script
    src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google_maps.api_key') }}&libraries=places&callback=initAutocomplete"
async defer></script>
@endsection
