<a href="{{ route('reports.show', [$report]) }}">
  <div class="bg-white w-full flex rounded-xl shadow">
    <div @click="if(reportImagesBlurred && {{ $report->isNotHealthy() ? 1 : 0 }}) { $dispatch('show-blur-modal'); return false;}" :class="{'blur':reportImagesBlurred && {{ $report->isNotHealthy() ? 1 : 0 }} }" class="h-auto w-48 flex-none bg-cover rounded-l-xl text-center overflow-hidden" style="background-image: url('{{ $report->firstImage }}'); background-position: center; background-size: cover;">
    </div>
    <div class="w-full p-4 flex flex-col justify-between leading-normal">
      <div class="mb-8">
        <div class="flex">
          <div class="w-1/2">
            <p class="text-gray-700 text-base">
              <i class="fa fa-calendar text-orange-500 pr-2"></i> {{ $report->createdAtDateTimeFormatted }}
            </p>
          </div>
          <div class="w-1/2 text-right">
            <p class="w-full text-gray-500 text-base">#{{ $report->id }}</p>
          </div>
        </div>
        <div class="mt-1">
          <p class="text-gray-700">
             <i class="fa fa-map-marker-alt text-orange-500 pr-2"></i> {{ $report->cityFormatted }}
          </p>
        </div>
        <div class="mt-4 mb-2">
          <span class="inline-block bg-gray-200 rounded-full px-3 py-1 text-sm font-semibold {{ $report->type == \Modules\Common\Entities\Report::TYPE_FOUND ? 'text-green-700' : 'text-red-700' }} mr-2 mb-2">{{ $report->typeFormatted }}</span>
          <span class="inline-block bg-gray-200 rounded-full px-3 py-1 text-sm font-semibold text-gray-700 mr-2 mb-2">{{ $report->animalSpeciesFormatted }}</span>
          <span class="inline-block bg-gray-200 rounded-full px-3 py-1 text-sm font-semibold text-gray-700 mr-2 mb-2">{{ $report->animalConditionFormatted }}</span>
        </div>
      </div>
    </div>
  </div>
</a>
