<section class="bg-gray-100 py-16">
  <div class="mx-auto container">
    <div class="mx-auto text-left text-black text-xl w-full lg:w-1/2">
      <form method="get" action="{{ route('reports.index') }}" class="mx-auto bg-white shadow rounded-xl px-6 py-6">

        <div class="flex gap-4">
          {{-- Type Filter --}}
          <div class="mb-6 w-full">
            <label class="text-gray-700 text-sm font-bold mb-2" for="type">
              {{ __('messages.global.report_type') }}
            </label>
            <select name="type" placeholder="{{ __('messages.global.type') }}"
              class="bg-white shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
              <option value="">{{ __('messages.report_type.all') }}</option>
              <option value="{{ Modules\Common\Entities\Report::TYPE_LOST }}"
                {{ Request::input('type') == Modules\Common\Entities\Report::TYPE_LOST ? 'selected' : '' }}>
                {{ __('messages.report_type.lost') }}</option>
              <option value="{{ Modules\Common\Entities\Report::TYPE_FOUND }}"
                {{ Request::input('type') == Modules\Common\Entities\Report::TYPE_FOUND ? 'selected' : '' }}>
                {{ __('messages.report_type.found') }}</option>
            </select>
          </div>
        </div>

        <div class="flex gap-4">
          {{-- Species Filter --}}
          <div class="mb-6 w-1/2">
            <label class="text-gray-700 text-sm font-bold mb-2" for="animal_species">
              {{ __('messages.global.animal_species') }}
            </label>
            <select id="animal_species" name="animal_species"
              placeholder="{{ __('messages.global.animal_species') }}"
              class="bg-white shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">

              {{-- All --}}
              <option value="">{{ __('messages.animal_species.all') }}</option>

              {{-- Pet --}}
              <option value="pet" class="font-bold text-orange-500"
                {{ Request::input('animal_species') == 'pet' ? 'selected' : '' }}>
                {{ __('messages.animal_species_categories.pet') }}
              </option>

              {{-- Pet Dog --}}
              <option value="pet_dog" class="font-bold text-orange-500"
                {{ Request::input('animal_species') == 'pet_dog' ? 'selected' : '' }}>
                &nbsp;&nbsp;{{ __('messages.animal_species_categories.pet_dog') }}
              </option>
              @foreach (Modules\Common\Entities\Animal::getAnimalSpeciesList() as $species)
                @if (Str::startsWith($species, 'pet_dog'))
                  <option value="{{ $species }}"
                    {{ Request::input('animal_species') == $species ? 'selected' : '' }}>
                    &nbsp;&nbsp;&nbsp;&nbsp;{{ __('messages.animal_species.' . $species) }}</option>
                @endif
              @endforeach

              {{-- Pet Cat --}}
              <option value="pet_cat" class="font-bold text-orange-500"
                {{ Request::input('animal_species') == 'pet_cat' ? 'selected' : '' }}>
                &nbsp;&nbsp;{{ __('messages.animal_species_categories.pet_cat') }}
              </option>
              @foreach (Modules\Common\Entities\Animal::getAnimalSpeciesList() as $species)
                @if (Str::startsWith($species, 'pet_cat'))
                  <option value="{{ $species }}"
                    {{ Request::input('animal_species') == $species ? 'selected' : '' }}>
                    &nbsp;&nbsp;&nbsp;&nbsp;{{ __('messages.animal_species.' . $species) }}</option>
                @endif
              @endforeach

              {{-- Pet Other --}}
              <option value="pet" class="font-bold text-orange-500">
                &nbsp;&nbsp;{{ __('messages.animal_species_categories.pet') }}
              </option>
              @foreach (Modules\Common\Entities\Animal::getAnimalSpeciesList() as $species)
                @if (Str::startsWith($species, 'pet') && !Str::startsWith($species, 'pet_dog') && !Str::startsWith($species, 'pet_cat'))
                  <option value="{{ $species }}"
                    {{ Request::input('animal_species') == $species ? 'selected' : '' }}>
                    &nbsp;&nbsp;&nbsp;&nbsp;{{ __('messages.animal_species.' . $species) }}</option>
                @endif
              @endforeach

              {{-- Livestock --}}
              <option value="livestock" class="font-bold text-orange-500"
                {{ Request::input('animal_species') == 'livestock' ? 'selected' : '' }}>
                {{ __('messages.animal_species_categories.livestock') }}
              </option>
              @foreach (Modules\Common\Entities\Animal::getAnimalSpeciesList() as $species)
                @if (Str::startsWith($species, 'livestock'))
                  <option value="{{ $species }}"
                    {{ Request::input('animal_species') == $species ? 'selected' : '' }}>
                    &nbsp;&nbsp;{{ __('messages.animal_species.' . $species) }}</option>
                @endif
              @endforeach

              {{-- Circus --}}
              <option value="circus" class="font-bold text-orange-500"
                {{ Request::input('animal_species') == 'circus' ? 'selected' : '' }}>
                {{ __('messages.animal_species_categories.circus') }}
              </option>
              @foreach (Modules\Common\Entities\Animal::getAnimalSpeciesList() as $species)
                @if (Str::startsWith($species, 'circus'))
                  <option value="{{ $species }}"
                    {{ Request::input('animal_species') == $species ? 'selected' : '' }}>
                    &nbsp;&nbsp;{{ __('messages.animal_species.' . $species) }}</option>
                @endif
              @endforeach

              {{-- Wild --}}
              <option value="wild" class="font-bold text-orange-500"
                {{ Request::input('animal_species') == 'wild' ? 'selected' : '' }}>
                {{ __('messages.animal_species_categories.wild') }}
              </option>
              @foreach (Modules\Common\Entities\Animal::getAnimalSpeciesList() as $species)
                @if (Str::startsWith($species, 'wild') && !Str::startsWith($species, 'wild_aquatic'))
                  <option value="{{ $species }}"
                    {{ Request::input('animal_species') == $species ? 'selected' : '' }}>
                    &nbsp;&nbsp;{{ __('messages.animal_species.' . $species) }}</option>
                @endif
              @endforeach

              {{-- Wild Aquatic --}}
              <option value="wild_aquatic" class="font-bold text-orange-500"
                {{ Request::input('animal_species') == 'wild_aquatic' ? 'selected' : '' }}>
                {{ __('messages.animal_species_categories.wild_aquatic') }}
              </option>
              @foreach (Modules\Common\Entities\Animal::getAnimalSpeciesList() as $species)
                @if (Str::startsWith($species, 'wild_aquatic'))
                  <option value="{{ $species }}"
                    {{ Request::input('animal_species') == $species ? 'selected' : '' }}>
                    &nbsp;&nbsp;{{ __('messages.animal_species.' . $species) }}</option>
                @endif
              @endforeach

            </select>

          </div>
          {{-- Animal Condition Filter --}}
          <div class="mb-6 w-1/2">
            <label class="text-gray-700 text-sm font-bold mb-2" for="type">
              {{ __('messages.global.animal_condition') }}
            </label>
            <select name="animal_condition" placeholder="{{ __('messages.global.animal_condition') }}"
              class="bg-white shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
              <option value="">{{ __('messages.animal_condition.all') }}</option>
              @foreach (Modules\Common\Entities\Animal::ANIMAL_CONDITIONS as $condition)
                <option value="{{ $condition }}"
                  {{ Request::input('animal_condition') == $condition ? 'selected' : '' }}>
                  {{ __('messages.animal_condition.' . $condition) }}</option>
              @endforeach
            </select>
          </div>
        </div>

        <div class="flex gap-4">
          {{-- Location Filter --}}
          <div class="mb-6 w-2/3">
            <label class="text-gray-700 text-sm font-bold mb-2" for="address">
              {{ __('messages.global.location') }}
            </label>
            <input type="text" id="location_address" name="address" value="{{ Request::input('address') }}"
              placeholder="{{ __('messages.global.city') }}"
              class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            <input type="hidden" id="location_latitude" name="latitude" value="{{ Request::input('latitude') }}">
            <input type="hidden" id="location_longitude" name="longitude" value="{{ Request::input('longitude') }}">
          </div>

          {{-- Radius Filter --}}
          <div class="mb-6 w-1/3">
            <label class="text-gray-700 text-sm font-bold mb-2" for="radius">
              {{ __('messages.global.radius') }}
            </label>
            <select name="radius" placeholder="{{ __('messages.global.radius') }}"
              class="bg-white shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
              <option value="">{{ __('messages.radius.all') }}</option>
              <option value="2" {{ Request::input('radius') == '2' ? 'selected' : '' }}>2 km</option>
              <option value="5" {{ Request::input('radius') == '5' ? 'selected' : '' }}>5 km</option>
              <option value="10" {{ Request::input('radius') == '10' ? 'selected' : '' }}>10 km
              </option>
              <option value="25" {{ Request::input('radius') == '25' ? 'selected' : '' }}>25 km
              </option>
              <option value="50" {{ Request::input('radius') == '50' ? 'selected' : '' }}>50 km
              </option>
              <option value="100" {{ Request::input('radius') == '100' ? 'selected' : '' }}>100 km
              </option>
            </select>
          </div>
        </div>

        {{-- Submit Button --}}
        <div class="text-center">
          <button type="submit"
            class="gradient text-white font-bold rounded-full mt-4 lg:mt-0 py-2 px-8 opacity-75 hover:opacity-100 shadow">
            {{ __('messages.global.filter') }}
          </button>
        </div>

      </form>
    </div>
  </div>
</section>
