@extends('blog::_layouts.master')

@section('title', __('messages.donate.title'))

@section('content')


  {{-- Header --}}
  <header class="pt-24">
    <div class="mx-auto container px-3 py-16">
      <div class="w-full text-center">
        <h1 class="my-4 text-5xl font-bold leading-tight">{{ __('messages.donate.title') }}</h1>
        <p class="leading-normal text-2xl mb-8">{!! __('messages.donate.subtitle') !!}</p>
      </div>
    </div>
  </header>


  {{-- Starting gradient --}}
  @include('landing::_layouts/_partials/gradient-start', [
      'fill' => '#ffffff',
  ])


  {{-- Section About --}}
  <section class="bg-white py-12">
    <div class="container mx-auto px-2 pt-4 pb-12 text-gray-700">
      <div class="mx-auto text-center text-black text-xl px-4 md:px-32 xl:px-64">
        <p class="mb-6">
          {!! __('messages.donate.content') !!}
        </p>
        <hr class="my-10">
        <p class="mb-6">
          Omdat het een publieke functie heeft en omdat wij vinden dat niemand zou moeten betalen om zijn huisdier te
          vinden, willen wij dat de applicatie gratis blijft.<br><br>Aan de toepassing zijn echter wel kosten verbonden,
          zowel voor de ontwikkeling van diensten die steeds meer aan uw behoeften worden aangepast, als voor het
          onderhoud ervan.<br><br>Daarom stellen wij een donatiesysteem ter beschikking van degenen die ons willen helpen
          in onze missie en de applicatie draaiende willen houden.<br><br>Deze giften kunnen eenmalig, regelmatig of
          occasioneel worden gedaan, zoals u wenst en zonder verplichting.
        </p>
      </div>
    </div>
  </section>

  {{-- Section Donate --}}
  <section class="bg-gray-100 py-8">
    <div class="container mx-auto px-2 pt-4 pb-12 text-gray-700">
      <div class="flex flex-wrap mt-24 gap-6">

        {{-- 1 --}}
        {{-- <div class="bg-white w-full md:w-1/3 text-center mx-auto py-12 rounded-xl shadow-lg p-6">
        <div>
          <h3 class="text-3xl font-bold leading-none mb-6">
            Teaming
          </h3>
          <div class="mt-2 text-base">
            <p class="py-2">
              <span class="text-primary font-bold">Don mensuel de 1 €</span>
            </p>
            <p class="py-2">
              <a class="mx-auto lg:mx-0 gradient text-white text-xs font-bold rounded-full my-4 py-3 px-6 shadow-lg" href="https://www.teaming.net/animalresearchapp" target="_blank">
                {{ __('messages.donate.action') }}
              </a>
            </p>
          </div>
        </div>
      </div> --}}

        {{-- 2 --}}
        <div class="bg-white w-full md:w-1/3 mx-auto py-12 text-center rounded-xl shadow-lg p-6">
          <div>
            <h3 class="text-3xl font-bold leading-none mb-6">
              {{ __('messages.global.bank_transfer') }}
            </h3>
            <div class="mt-2 text-base">
              <p class="py-2">
                <span class="text-primary font-bold">{{ __('messages.global.donate_through_your_bank') }}</span><br>
                BE11 9501 4287 2948
              </p>
              <p class="py-2">
                <span class="text-primary font-bold">{{ __('messages.global.communication') }}</span><br>
                Don AR ASBL [{{ __('messages.global.your_name') }}]
              </p>
            </div>
          </div>
        </div>

      </div>
    </div>
  </section>


  {{-- Ending gradient --}}
  @include('landing::_layouts/_partials/gradient-end', ['fill' => '#f7fafc'])


@endsection
