@php
$browserUserAgent = Request::header('User-Agent');
$browserIsSafari = Str::contains($browserUserAgent, 'Safari') && !Str::contains($browserUserAgent, 'Chrome');
@endphp

<!doctype html>
<html lang="fr">

<head>
  {{-- Meta --}}
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <meta name="description" content="@yield('title')">
  <meta name="author" content="{{ config('app.name') }}">
  @yield('meta')

  {{-- Title --}}
  <title>@yield('title') | {{ config('app.name') }}</title>

  {{-- Favicon --}}
  <link rel="icon" type="image/png" href="{{ asset('common/img/favicon.png') }}">

  {{-- Styles --}}
  <link rel="stylesheet" href="https://unpkg.com/tailwindcss@^1.0/dist/tailwind.min.css">
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:400,700">
  <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.3.1/css/all.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/animatecss/3.4.0/animate.min.css">
  <link rel="stylesheet" href="{{ asset('landing/css/morphext.css') }}">

  {{-- Additional Styles --}}
  <style>
    .gradient {
      background: linear-gradient(90deg, rgba(188, 32, 75, .8) 0%, rgba(255, 170, 77, .8) 100%);
    }

    .gradient-with-background {
      background: linear-gradient(90deg, rgba(188, 32, 75, .8) 0%, rgba(255, 170, 77, .8) 100%), url({{ asset('landing/images/bg/dog.jpg') }}) no-repeat;
      background-size: cover;
      background-position: bottom;
    }

    .bokeh {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      z-index: -1;
      background: url({{ asset('landing/images/bg/bokeh.jpg') }}) no-repeat;
      background-size: cover;
      background-attachment: fixed;
      mix-blend-mode: overlay;
      opacity: 0.6;
    }

    .blur {
      -webkit-filter: blur(5px);
      filter: blur(5px);
    }

  </style>

  @yield('css')

</head>

<body x-data="{ reportImagesBlurred: true }" x-on:unblur-report-images.window="reportImagesBlurred = false"
  class="leading-normal tracking-normal text-white gradient-with-background"
  style="font-family: 'Source Sans Pro', sans-serif; background-attachment: fixed;">

  <div class="bokeh"></div>

  {{-- Nav --}}
  @include('landing::_layouts/_includes/nav')

  {{-- Content --}}
  @yield('content')

  {{-- Donate --}}
  @include('landing::_layouts/_includes/donate')

  {{-- Footer --}}
  @include('landing::_layouts/_includes/footer')

  {{-- Blur Modal --}}
  @include('landing::_layouts/_includes/blur-modal')

  {{-- Cookie Consent --}}
  @include('cookieConsent::index')

  {{-- Scripts --}}
  <script src="https://cdn.jsdelivr.net/gh/alpinejs/alpine@v2.x.x/dist/alpine.js" defer></script>
  <script src="https://unpkg.com/@themesberg/flowbite@1.1.1/dist/datepicker.bundle.js"></script>
  <script src="https://unpkg.com/flowbite@1.5.3/dist/flowbite.js"></script>
  <script src="{{ asset('landing/js/jquery-3.5.1.min.js') }}"></script>
  <script src="{{ asset('landing/js/morphext.min.js') }}"></script>
  <script src="{{ asset('landing/js/scripts.js') }}"></script> {{-- Custom scripts --}}

  {{-- Google Translate --}}
  <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit">
  </script>
  <script type="text/javascript">
    function googleTranslateElementInit() {
      new google.translate.TranslateElement({
        pageLanguage: 'fr'
      }, 'google_translate_element');
    }
  </script>

  {{-- Additional JS --}}
  @yield('js')

</body>

</html>
