<nav id="header" class="fixed w-full z-30 top-0 text-white">

  <div class="w-full mx-auto px-4 flex flex-wrap items-center justify-between mt-0 py-2">

    <div class="pl-4 flex items-center">
      <a class="no-underline hover:no-underline"  href="{{ route('landing.home.index') }}">
        <img id="nav-logo" class="h-16" src="{{ asset('landing/images/logo-white.png') }}" alt="{{ config('app.name') }}">
      </a>
    </div>

    <div class="block lg:hidden pr-4">
      <button id="nav-toggle" class="flex items-center p-1 text-orange-800 hover:text-gray-900">
        <svg class="fill-current h-6 w-6" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><title>Menu</title><path d="M0 3h20v2H0V3zm0 6h20v2H0V9zm0 6h20v2H0v-2z"/></svg>
      </button>
    </div>

    <div class="w-full flex-grow lg:flex lg:items-center lg:w-auto hidden lg:block mt-2 lg:mt-0 bg-white lg:bg-transparent text-black p-4 lg:p-0 z-20" id="nav-content">
      <ul class="list-reset lg:flex justify-end flex-1 items-center mb-4 lg:mb-0 text-sm">
        <li class="mr-3">
          <a class="toggleColour inline-block text-gray-800 lg:text-white xl:text-white hover:opacity-100 font-bold py-2 px-4 {{{ (Str::startsWith(Route::currentRouteName(), 'landing.home')) ? 'opacity-100' : 'opacity-75' }}}" href="{{ route('landing.home.index') }}">
            <i class="fa fa-home"></i>
            {{ __('messages.global.home') }}
          </a>
        </li>
        <li class="mr-3">
          <a class="toggleColour inline-block text-gray-800 lg:text-white xl:text-white hover:opacity-100 font-bold py-2 px-4 {{{ (Str::startsWith(Route::currentRouteName(), 'blog')) ? 'opacity-100' : 'opacity-75' }}}" href="{{ route('blog.index') }}">
            <i class="fa fa-newspaper"></i>
            {{ __('messages.global.blog') }}
          </a>
        </li>
        <li class="mr-3">
          <a class="toggleColour inline-block text-gray-800 lg:text-white xl:text-white hover:opacity-100 font-bold py-2 px-4 {{{ (Str::startsWith(Route::currentRouteName(), 'reports')) ? 'opacity-100' : 'opacity-75' }}}" href="{{ route('reports.index', ['radius' => 10]) }}">
            <i class="fa fa-paw"></i> 
            {{ __('messages.global.lost_and_found_animals') }}
          </a>
        </li>
        <li class="mr-3">
          <a class="toggleColour inline-block text-gray-800 lg:text-white xl:text-white hover:opacity-100 font-bold py-2 px-4 {{{ (Str::startsWith(Route::currentRouteName(), 'user.reports.create')) ? 'opacity-100' : 'opacity-75' }}}" href="{{ route('user.reports.create') }}">
            <i class="fa fa-exclamation"></i>
            {{ __('messages.global.report_his_lost_animal') }}
          </a>
        </li>
        @if(!$browserIsSafari)
        <li class="mr-3">
          <a class="toggleColour inline-block text-gray-800 lg:text-white xl:text-white hover:opacity-100 font-bold py-2 px-4 {{{ (Str::startsWith(Route::currentRouteName(), 'landing.donate')) ? 'opacity-100' : 'opacity-75' }}}" href="{{ route('landing.donate.index') }}">
            <i class="fa fa-life-ring"></i> 
            {{ __('messages.global.donate') }}
          </a>
        </li>
        @endif
        <li class="mr-3">
          <a class="toggleColour inline-block text-gray-800 lg:text-white xl:text-white hover:opacity-100 font-bold py-2 px-4 {{{ (Str::startsWith(Route::currentRouteName(), 'contact')) ? 'opacity-100' : 'opacity-75' }}}" href="{{ route('contact.index') }}">
            <i class="fa fa-envelope"></i> 
            {{ __('messages.global.contact_us') }}
          </a>
        </li>
        <li class="mr-3">
            <button class="toggleColour text-gray-800 lg:text-white xl:text-white hover:opacity-100 font-bold py-2 px-4 uppercase" data-dropdown-toggle="dropdown">
              <i class="fa fa-globe"></i> 
              {{ app()->getLocale() }}
            </button>
            <div id="dropdown" class="hidden z-10 w-44 bg-white rounded divide-y divide-gray-100 shadow">
              <ul>
                @foreach(config('app.languages') as $language)
                @php
                $parameters = request()->route()->parameters();
                $parameters['locale'] = $language['prefix'];
                @endphp
                <li>
                  <a class="block py-2 px-4 hover:bg-gray-100" href="{{ route(request()->route()->getName(), $parameters) }}">
                    {{ $language['title'] }}
                  </a>
                </li>
                @endforeach
              </ul>
            </div>
          </li>
      </ul>
      <a id="navAction" class="mx-auto lg:mx-0 bg-white text-orange-600 font-bold rounded-full mt-4 lg:mt-0 py-2 px-8 opacity-75 hover:opacity-100 shadow text-sm" href="{{ route('user.auth.login') }}">
        <i class="fa fa-user"></i> 
        @guest('user')
        {{ __('messages.global.user_area') }}
        @endguest
        @auth('user')
        {{ auth('user')->user()->fullNameSafe }}
        @endauth
      </a>
    </div>
  </div>

  <hr class="border-b border-gray-100 opacity-25 my-0 py-0" />
</nav>
