<?php

namespace Modules\Common\Tests\Feature\Database;

use Illuminate\Database\Eloquent\Collection;
use Modules\Common\Entities\Abuse;
use Modules\Common\Entities\Alert;
use Modules\Common\Entities\NotificationToken;
use Modules\Common\Entities\RegisteredAnimal;
use Modules\Common\Entities\Report;
use Modules\Common\Entities\User;

use Schema;


class UserTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testUsersTableHasExpectedColumns()
    {
        $this->assertTrue(
            Schema::hasColumns('users', [
                'id', 'email', 'password', 'first_name', 'last_name', 'phone',
                'phone_is_private', 'address', 'address_is_private', 'gender',
                'date_of_birth', 'location_zipcode', 'location_country',
                'extras', 'account_type', 'is_verified', 'is_blocked', 'force_premium',
                'remember_token', 'email_verified_at', 'phone_verified_at',
                'created_at', 'updated_at', 'deleted_at',
            ])
        );
    }
    /***************************************************************************
     * User-NotificationTokens relationship
     **************************************************************************/
    public function testUserHasManyNotificationTokens()
    {
        $user = User::find(1);
        $notificationToken = NotificationToken::find(1);

        $this->assertInstanceOf(Collection::class, $user->notificationTokens);
        $this->assertTrue($user->notificationTokens->contains($notificationToken));
    }

    /***************************************************************************
     * User-Reports relationship
     **************************************************************************/
    public function testUserHasManyReports()
    {
        $user = User::find(1);
        $report = Report::find(1);
        $otherReport = Report::find(3);

        $this->assertInstanceOf(Collection::class, $user->reports);
        $this->assertTrue($user->reports->contains($report));
        $this->assertFalse($user->reports->contains($otherReport));
    }

    /***************************************************************************
     * User-RegisteredAnimals relationship
     **************************************************************************/
    public function testUserHasManyRegisteredAnimals()
    {
        $user = User::find(1);
        $animal = RegisteredAnimal::find(1);
        $otherAnimal = RegisteredAnimal::find(2);

        $this->assertInstanceOf(Collection::class, $user->registeredAnimals);
        $this->assertTrue($user->registeredAnimals->contains($animal));
        $this->assertFalse($user->registeredAnimals->contains($otherAnimal));
    }

    /***************************************************************************
     * User-Alerts relationship
     **************************************************************************/
    public function testUserHasManyAlerts()
    {
        $user = User::find(1);
        $alert = Alert::find(1);
        $otherAlert = Alert::find(2);

        $this->assertInstanceOf(Collection::class, $user->alerts);
        $this->assertTrue($user->alerts->contains($alert));
        $this->assertFalse($user->alerts->contains($otherAlert));
    }

    /***************************************************************************
     * User-Abuses relationship
     **************************************************************************/
    public function testUserHasManyAbuses()
    {
        $user = User::find(1);
        $abuse = Abuse::find(1);
        $otherAbuse = Abuse::find(2);

        $this->assertInstanceOf(Collection::class, $user->abuses);
        $this->assertTrue($user->abuses->contains($abuse));
        $this->assertTrue($user->abuses->contains($otherAbuse));
    }

    // End of class
}
