<?php

namespace Modules\Common\Tests\Feature\Database;

use Modules\Common\Entities\Abuse;
use Modules\Common\Entities\Report;
use Modules\Common\Entities\User;

use Schema;


class ReportTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testReportsTableHasExpectedColumns()
    {
        $this->assertTrue(
            Schema::hasColumns('reports', [
                'id', 'user_id', 'location_address', 'location_latitude',
                'location_longitude', 'location_zipcode', 'location_country',
                'type', 'animal_species', 'animal_condition', 'identification_type',
                'identification_number', 'final_location', 'comment', 'state',
                'deletion_reason', 'deletion_reason_comment', 'created_at',
                'updated_at', 'expires_at', 'deleted_at',
            ])
        );
    }

    /***************************************************************************
     * Report-User relationship
     **************************************************************************/
    public function testReportBelongsToUser()
    {
        $report = Report::find(1);
        $user = User::find(1);

        $this->assertInstanceOf(User::class, $report->user);
        $this->assertTrue($report->user == $user);
    }

    /***************************************************************************
     * Report-Abuses relationship
     **************************************************************************/
    public function testReportHasManyAbuses()
    {
        $report = Report::find(3);
        $abuse = Abuse::find(1);

        $this->assertInstanceOf('Illuminate\Database\Eloquent\Collection', $report->abuses);
        $this->assertTrue($report->abuses->contains($abuse));
    }

    // End of class
}
