<?php

namespace Modules\Common\Tests\Feature\Database;

use Modules\Common\Entities\RegisteredAnimal;
use Modules\Common\Entities\User;

use Schema;


class RegisteredAnimalTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testRegisteredAnimalsTableHasExpectedColumns()
    {
        $this->assertTrue(
            Schema::hasColumns('registered_animals', [
                'id', 'user_id', 'name', 'animal_species', 'identification_type',
                'identification_number', 'comment', 'created_at', 'updated_at',
            ])
        );
    }

    /***************************************************************************
     * RegisteredAnimal-User relationship
     **************************************************************************/
    public function testRegisteredAnimalBelongsToUser()
    {
        $animal = RegisteredAnimal::find(1);
        $user = User::find(1);

        $this->assertInstanceOf(User::class, $animal->user);
        $this->assertTrue($animal->user == $user);
    }

    // End of class
}
