<?php

namespace Modules\Common\Tests\Feature\Database;

use Modules\Common\Entities\User;
use Modules\Common\Entities\NotificationToken;

use Schema;


class NotificationTokenTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testNotificationTokensTableHasExpectedColumns()
    {
        $this->assertTrue(
            Schema::hasColumns('notification_tokens', [
                'id', 'user_id', 'access_token', 'token', 'created_at',
                'updated_at',
            ])
        );
    }

    /***************************************************************************
     * NotificationToken-User relationship
     **************************************************************************/
    public function testNotificationTokenBelongsToUser()
    {
        $notificationToken = NotificationToken::find(1);
        $user = User::find(1);

        $this->assertInstanceOf(User::class, $notificationToken->user);
        $this->assertTrue($notificationToken->user == $user);
    }

    // End of class
}
