<?php

namespace Modules\Common\Tests\Feature\Database;

use Modules\Common\Entities\Alert;
use Modules\Common\Entities\User;

use Schema;


class AlertTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testAlertsTableHasExpectedColumns()
    {
        $this->assertTrue(
            Schema::hasColumns('alerts', [
                'id', 'user_id', 'animal_species', 'location_address',
                'location_latitude', 'location_longitude', 'radius',
                'created_at', 'updated_at',
            ])
        );
    }

    /***************************************************************************
     * Alert-User relationship
     **************************************************************************/
    public function testAlertBelongsToUser()
    {
        $alert = Alert::find(1);
        $user = User::find(1);

        $this->assertInstanceOf(User::class, $alert->user);
        $this->assertTrue($alert->user == $user);
    }

    // End of class
}
