<?php

namespace Modules\Common\Tests\Feature\Database;

use Modules\Common\Entities\Abuse;
use Modules\Common\Entities\Report;
use Modules\Common\Entities\User;

use Schema;


class AbuseTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testAbusesTableHasExpectedColumns()
    {
        $this->assertTrue(
            Schema::hasColumns('abuses', [
                'id', 'user_id', 'abusable_type', 'abusable_id', 'type',
                'comment', 'state', 'created_at', 'updated_at',
            ])
        );
    }

    /***************************************************************************
     * Abuse-User relationship
     **************************************************************************/
    public function testAbuseBelongsToUser()
    {
        $abuse = Abuse::find(1);
        $user = User::find(1);

        $this->assertInstanceOf(User::class, $abuse->user);
        $this->assertTrue($abuse->user == $user);
    }

    /***************************************************************************
     * Abuse-Report relationship
     **************************************************************************/
    public function testAbuseBelongsToReport()
    {
        $abuse = Abuse::find(1);
        $report = Report::find(3);

        $this->assertInstanceOf(Report::class, $abuse->abusable);
        $this->assertTrue($abuse->abusable == $report);
    }

    // End of class
}
