<?php

namespace Modules\Common\Observers;

use Spatie\Geocoder\Geocoder;
use Modules\Common\Entities\Report;


class ReportObserver
{

    /***************************************************************************
     * Events
     **************************************************************************/
    public function created(Report $report)
    {
        // Update address if needed
        if ($report->hasIncompleteAddress()) {
            $this->updateAddress($report);
        }
    }

    public function updated(Report $report)
    {
        // Update address if needed
        if ($report->hasIncompleteAddress()) {
            $this->updateAddress($report);
        }
    }

    /***************************************************************************
     * Utils
     **************************************************************************/
    private function updateAddress(Report $report)
    {
        try {
            // Init. Geocoder
            $geocoder = $this->createGeocoder();

            // Prepare variables
            $lat = $report->location_latitude;
            $lng = $report->location_longitude;

            // Get location
            $location = $geocoder->getAddressForCoordinates($lat, $lng);

            // Update address from location
            if (!$report->location_address) {
                $report->location_address = $location['formatted_address'];
            }

            // Exctract components
            foreach ($location['address_components'] as $component) {
                if ($component->types[0] == 'postal_code') {
                    $report->location_zipcode = $component->short_name;
                }
                if ($component->types[0] == 'country') {
                    $report->location_country = $component->short_name;
                }
            }

            // Save report
            $report->save();
        } catch (\Throwable $e) {
            // Handle error
        }
    }

    private function createGeocoder()
    {
        // Init. Geocoder
        $client = new \GuzzleHttp\Client();
        $geocoder = new Geocoder($client);

        // Set Geocoder
        $geocoder->setApiKey(config('geocoder.key'));
        $geocoder->setLanguage(config('geocoder.language'));

        // Return Geocoder
        return $geocoder;
    }

    // End of class
}
