<?php

namespace Modules\Common\Observers;

use Modules\Common\Entities\Abuse;
use Modules\Common\Notifications\NotifyUserOfSuspendedReport;
use Modules\Common\Notifications\NotifyUserOfUnsuspendedReport;


class AbuseObserver
{

    /***************************************************************************
     * Events
     **************************************************************************/
    public function created(Abuse $abuse)
    {
        $this->notifyIfAbusesExists($abuse);
    }

    public function updated(Abuse $abuse)
    {
        $this->notifyIfAbusesExists($abuse);
        $this->notifyIfAbusesNotExists($abuse);
    }

    public function deleted(Abuse $abuse)
    {
        $this->notifyIfAbusesNotExists($abuse);
    }

    /***************************************************************************
     * Utils
     **************************************************************************/
    private function notifyIfAbusesNotExists(Abuse $abuse)
    {
        // Get number of abuses for report
        $abusesCount = $this->countAbuses($abuse);

        // Notify user if its report has no one abuses anymore
        if ($abusesCount == 0) {
            $abuse->abusable->user->notify(new NotifyUserOfUnsuspendedReport($abuse));
        }
    }

    private function notifyIfAbusesExists(Abuse $abuse)
    {
        // Get number of abuses for report
        $abusesCount = $this->countAbuses($abuse);

        // Notify user if its report has only one abuse
        if ($abusesCount == 1) {
            $abuse->abusable->user->notify(new NotifyUserOfSuspendedReport($abuse));
        }
    }

    private function countAbuses(Abuse $abuse): int
    {
        return $abuse->abusable->abuses()->waiting()->count();
    }


    // End of class
}
