<?php

namespace Modules\Common\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

use Modules\Common\Entities\Report;

class ReportDeleteRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'deletion_reason'         => ['required', Rule::in(Report::DELETION_REASONS)],
            'deletion_reason_comment' => ['exclude_unless:deletion_reason,' . Report::DELETION_REASON_OTHER, 'required', 'string', 'max:1000'],
        ];
    }

    // End of class
}
