<?php

namespace Modules\Common\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;


class MediaStoreRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'image' => ['required', 'file', 'mimes:jpg,jpeg', 'max:15360'],
        ];
    }

    public function attributes()
    {
        return [];
    }

    public function messages()
    {
        return [
            'image.max' => "L'image dépasse la taille maximale autorisée de 15 Mo"
        ];
    }

    // End of class
}
