<?php

namespace Modules\Common\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

use Modules\Common\Entities\Abuse;

class AbuseStoreRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'type'    => ['required', Rule::in(Abuse::TYPES)],
            'comment' => ['required', 'string', 'max:1000'],
        ];
    }

    // End of class
}
