<?php

namespace Modules\Common\Entities\Traits;


trait Localizable
{
    public function scopeInRadius($query, $coordinates, $radius = 100)
    {
        $haversine = $this->haversine($coordinates);
        return $query->whereRaw("{$haversine} < {$radius}");
    }

    public function scopeInRadiusByField($query, $coordinates, $field = 'radius')
    {
        $haversine = $this->haversine($coordinates);
        return $query->whereRaw("{$haversine} < `{$field}`");
    }

    public function scopeWithDistance($query, $coordinates)
    {
        $haversine = $this->haversine($coordinates);
        return $query->select()->selectRaw("{$haversine} as location_distance");
    }

    private function haversine($coordinates)
    {
        return "(6371 * acos(cos(radians(" . $coordinates['latitude'] . "))
        * cos(radians(`location_latitude`))
        * cos(radians(`location_longitude`)
        - radians(" . $coordinates['longitude'] . "))
        + sin(radians(" . $coordinates['latitude'] . "))
        * sin(radians(`location_latitude`))))";
    }

    // End of class
}
