<?php

namespace Modules\Common\Entities\Scopes;

use Modules\Common\Entities\User;


trait UserScopes
{

    public function scopeIsIndividual($query)
    {
        return $query->where('account_type', User::ACCOUNT_TYPE_INDIVIDUAL);
    }

    public function scopeIsOrganization($query)
    {
        return $query->where('account_type', User::ACCOUNT_TYPE_ORGANIZATION);
    }

    public function scopeIsOrganizationAccess($query)
    {
        return $query->where('account_type', User::ACCOUNT_TYPE_ACCESS);
    }

    public function scopeIsVerified($query)
    {
        return $query->where('is_verified', true);
    }

    public function scopeIsNotVerified($query)
    {
        return $query->where('is_verified', false);
    }

    public function scopeDeletedSinceInDays($query, $days)
    {
        return $query->whereRaw('TIMESTAMPDIFF(DAY, deleted_at, NOW()) >= ?', [$days]);
    }

    public function scopeFilterByPremium($query)
    {
        return $query->whereHas('premiumCities')->orWhere('force_premium', true);
    }

    public function scopeFilterByNotPremium($query)
    {
        return $query->whereDoesntHave('premiumCities')->Where('force_premium', false);
    }

    // End of class
}
