<?php

namespace Modules\Common\Entities\Scopes;

use Modules\Common\Entities\Abuse;
use Modules\Common\Entities\Report;
use Carbon\Carbon;


trait ReportScopes
{


    /***************************************************************************
     * Scopes
     **************************************************************************/
    public function scopeWaiting($query)
    {
        return $query->where('state', Report::STATE_WAITING);
    }

    public function scopeDone($query)
    {
        return $query->where('state', Report::STATE_DONE);
    }

    public function scopeLost($query)
    {
        return $query->where('type', Report::TYPE_LOST);
    }

    public function scopeFound($query)
    {
        return $query->where('type', Report::TYPE_FOUND);
    }

    public function scopeNotExpired($query)
    {
        return $query->where('expires_at', '>', Carbon::now());
    }

    public function scopeAvailable($query)
    {
        return $query->waiting()->NotExpired()->whereDoesntHave('abuses', function ($abuses) {
            $abuses->where('state', Abuse::STATE_WAITING);
        });
    }

    public function scopeRemainingHours($query, $hoursRemaining)
    {
        return $query->whereRaw('TIMESTAMPDIFF(HOUR, NOW(), expires_at) = ?', [$hoursRemaining]);
    }

    // End of class
}
