<?php

namespace Modules\Common\Entities;

use Illuminate\Database\Eloquent\Model;

use Backpack\CRUD\app\Models\Traits\CrudTrait;
use Spatie\MediaLibrary\Models\Media;
use Spatie\MediaLibrary\HasMedia\HasMedia;
use Spatie\MediaLibrary\HasMedia\HasMediaTrait;

use Modules\Common\Entities\Presenters\AnimalPresenter;

class RegisteredAnimal extends Model implements HasMedia
{
    use AnimalPresenter, HasMediaTrait, CrudTrait;

    /***************************************************************************
     * Attributes
     **************************************************************************/
    protected $fillable = [
        'user_id', 'name', 'animal_species', 'identification_type',
        'identification_number', 'comment',
    ];

    protected $hidden = [
        'user_id',
    ];

    /***************************************************************************
     * Relationships
     **************************************************************************/
    public function user()
    {
        return $this->belongsTo(User::class)->withDefault(User::DEFAULT_VALUES);
    }

    /***************************************************************************
     * Media Conversions
     **************************************************************************/
    public function registerMediaConversions(Media $media = null)
    {
        $this->addMediaConversion('medium')
            ->width(1024)
            ->height(1024);

        $this->addMediaConversion('thumb')
            ->width(256)
            ->height(256);
    }

    // End of class
}
