<?php

namespace Modules\Common\Entities\Presenters;

use Avatar;

trait UserPresenter
{

    public function getAccountTypeFormattedAttribute()
    {
        return __('messages.account_type.' . $this->account_type);
    }

    public function getFullNameAttribute()
    {
        return implode(' ', [
            ucfirst($this->first_name),
            ucfirst($this->last_name),
        ]);
    }

    public function getFullNameSafeAttribute()
    {
        return implode(' ', [
            ucfirst($this->first_name),
            ucfirst($this->last_name[0]) . '.',
        ]);
    }

    public function getDisplayNameAttribute()
    {
        if ($this->isOrganization || $this->isOrganizationAccess) {
            return $this->organizationName;
        } else {
            return $this->fullNameSafe;
        }
    }

    public function getAvatarAttribute()
    {
        return Avatar::create($this->fullName)->toBase64();
    }

    public function getCreatedAtDateFormattedAttribute()
    {
        return $this->created_at->format('d/m/Y');
    }

    public function getCreatedAtDateTimeFormattedAttribute()
    {
        return $this->created_at->format('d/m/Y - H:i');
    }

    // End of class
}
