<?php

namespace Modules\Common\Entities\Presenters;

trait AnimalPresenter
{

    public function getAnimalSpeciesFormattedAttribute()
    {
        return __('messages.animal_species.' . $this->animal_species);
    }

    public function getIdentificationTypeFormattedAttribute()
    {
        return $this->identification_type ? __('messages.identification_type.' . $this->identification_type) : '';
    }

    public function getImagesAttribute()
    {
        $images = [];
        foreach ($this->getMedia() as $media) {
            $images[] = $media->getFullUrl('medium');
        }
        return $images;
    }

    public function getThumbnailsAttribute()
    {
        $images = [];
        foreach ($this->getMedia() as $media) {
            $images[] = [
                'url'  => $media->getFullUrl('thumb'),
                'name' => $media->file_name,
                'size' => $media->size,
            ];
        }
        return $images;
    }

    public function getFirstImageAttribute()
    {
        $media = $this->getFirstMedia();
        return $media ? $media->getFullUrl('medium') : '';
    }

    public function getThumbnailAttribute()
    {
        $media = $this->getFirstMedia();
        return $media ? $media->getFullUrl('thumb') : null;
    }

    // End of class
}
