<?php

namespace Modules\Common\Entities;

use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\app\Models\Traits\CrudTrait;


class PremiumCity extends Model
{
    use CrudTrait;

    /***************************************************************************
     * Attributes
     **************************************************************************/
    protected $fillable = ['city', 'zipcodes', 'country'];

    /***************************************************************************
     * Scopes
     **************************************************************************/
    public function scopeInZipcodes($query, $zipcode)
    {
        return $query->whereRaw('FIND_IN_SET(?, REPLACE(zipcodes, " ", ""))', [
            $zipcode,
        ]);
    }

    /***************************************************************************
     * Countries Values
     **************************************************************************/
    const COUNTRY_BELGIUM = 'BE';
    const COUNTRY_FRANCE = 'FR';

    const COUNTRIES = [
        self::COUNTRY_BELGIUM,
        self::COUNTRY_FRANCE,
    ];

    // End of class
}
